/*--------------------------------------------------------
   POPFIND.C -- Popup Editor Search and Replace Functions
  --------------------------------------------------------*/

#include <windows.h>
#include <windowsx.h>

#include <commdlg.h>
#include <string.h>

#include "resource.h"


#define MAX_STRING_LEN   256

static TCHAR szFindText [MAX_STRING_LEN] ;
static TCHAR szReplText [MAX_STRING_LEN] ;

static BOOL g_bFindMatchWholeWordOnly = FALSE;
static BOOL g_bFindMatchCase = FALSE;
static BOOL g_bFindDirectionUP = FALSE; //FALSE is down

		// Process "Find-Replace" iMsgs
		/* 
				if (iMsg == iMsgFindReplace)
				{
					pfr = (LPFINDREPLACE) lParam ;

					if (pfr->Flags & FR_DIALOGTERM)
							 hDlgModeless = NULL ;

					if (pfr->Flags & FR_FINDNEXT)
							 if (!PopFindFindText (g_hwndEdit, &iOffset, pfr))
										OkMessage (hwnd, TEXT("Text not found!"), TEXT("\0")) ;

					if (pfr->Flags & FR_REPLACE ||
							pfr->Flags & FR_REPLACEALL)
							 if (!PopFindReplaceText (g_hwndEdit, &iOffset, pfr))
										OkMessage (hwnd, TEXT("Text not found!"), TEXT("\0")) ;

					if (pfr->Flags & FR_REPLACEALL)
							 while (PopFindReplaceText (g_hwndEdit, &iOffset, pfr)) ;

					return 0 ;
				}
*/

//------------------------------------------------------
// FindDlgProc(HWND, WORD, WORD, LONG)
//------------------------------------------------------

BOOL CALLBACK FindDlgProc(HWND hwnd, WORD msg, WORD wp, LONG lp)

{  
	LRESULT	lResult = TRUE;

	switch(msg)
	{
		case WM_COMMAND:
			switch (GET_WM_COMMAND_ID(wp,lp))
				{
				case IDB_FIND_FINDNEXT:
					//get dialog field values
					//gset direction
					if(Button_GetCheck(GetDlgItem(hwnd,IDB_FIND_UP))) 
					{
						g_bFindDirectionUP = TRUE;
					} else
					{
						g_bFindDirectionUP = FALSE;
					}

					//get Match checkboxes
					if(Button_GetCheck(GetDlgItem(hwnd,IDC_FIND_MATCHWHOLEWORD)))
					{
						g_bFindMatchWholeWordOnly	= TRUE;					
					} else
					{
						g_bFindMatchWholeWordOnly	= FALSE;					
					}
					if(Button_GetCheck(GetDlgItem(hwnd,IDC_FIND_MATCHCASE))) 
					{
						g_bFindMatchCase = TRUE; 
					} else
					{
						g_bFindMatchCase = FALSE; 
					}

					//get find text 
					Edit_GetText(GetDlgItem(hwnd,IDE_FIND_FINDWHAT), szFindText, MAX_STRING_LEN); 
					//Do find
					if (!PopFindFindText (g_hwndEdit, &iOffset, szFindText))
										OkMessage (hwnd, TEXT("Text not found!"), TEXT("\0")) ;
					break;

				case IDB_FIND_CANCEL:
					EndDialog(hwnd, TRUE);
					break;
				}
			break;

			case WM_INITDIALOG:
				//set direction
				if(g_bFindDirectionUP) Button_SetCheck(GetDlgItem(hwnd,IDB_FIND_UP), BST_CHECKED); 
				if(!g_bFindDirectionUP) Button_SetCheck(GetDlgItem(hwnd,IDB_FIND_FINDDOWN), BST_CHECKED); 
				//set Match checkboxes
				if(g_bFindMatchWholeWordOnly) 
				{
					Button_SetCheck(GetDlgItem(hwnd,IDC_FIND_MATCHWHOLEWORD), BST_CHECKED); 
				} else
				{
					Button_SetCheck(GetDlgItem(hwnd,IDC_FIND_MATCHWHOLEWORD), BST_UNCHECKED); 
				}
				if(g_bFindMatchCase) 
				{
					Button_SetCheck(GetDlgItem(hwnd,IDC_FIND_MATCHCASE), BST_CHECKED); 
				} else
				{
					Button_SetCheck(GetDlgItem(hwnd,IDC_FIND_MATCHCASE), BST_UNCHECKED); 
				}

				//set find text 
				if(szFindText) Edit_SetText(GetDlgItem(hwnd,IDE_FIND_FINDWHAT), szFindText); 
				
				break;

		default:
			return(FALSE);
			break;
	}

  UNREFERENCED_PARAMETER(wp);
  UNREFERENCED_PARAMETER(lp);
	return (lResult);
}


//------------------------------------------------------
// ReplaceDlgProc(HWND, WORD, WORD, LONG)
//------------------------------------------------------

BOOL CALLBACK ReplaceDlgProc(HWND hwnd, WORD msg, WORD wp, LONG lp)

{  
	LRESULT	lResult = TRUE;

	switch(msg)
	{
		case WM_COMMAND:
			switch (GET_WM_COMMAND_ID(wp,lp))
				{
				//case IDC_CHECK1:
				//		g_bTextLineFeed = Button_GetCheck((HWND)lp); 
				//	break;


				case IDOK:
					EndDialog(hwnd, TRUE);
					break;
				}
			break;

			case WM_INITDIALOG:
				//if(g_bTextLineFeed) Button_SetCheck(GetDlgItem(hwnd,IDC_CHECK1), BST_CHECKED); 
				break;

		default:
			return(FALSE);
			break;
	}

  UNREFERENCED_PARAMETER(wp);
  UNREFERENCED_PARAMETER(lp);
	return (lResult);
}

//------------------------------------------------------
// PopFindFindDlg
//------------------------------------------------------

BOOL PopFindFindDlg (HWND hwnd, HINSTANCE g_hInst)
{
	return(DialogBox (g_hInst, MAKEINTRESOURCE(IDD_FIND), hwnd, (DLGPROC)FindDlgProc)) ;
}

//------------------------------------------------------
// PopFindFindDlg
//------------------------------------------------------

BOOL PopFindReplaceDlg (HWND hwnd, HINSTANCE g_hInst)
{
	return(DialogBox (g_hInst, MAKEINTRESOURCE(IDD_REPLACE), hwnd, (DLGPROC)ReplaceDlgProc)) ;

}

//------------------------------------------------------
// PopFindFindText
//------------------------------------------------------


BOOL PopFindFindText (HWND hwndEdit, int *piSearchOffset, LPTSTR szFindText)
{
	int   iLength, iPos ;
	LPTSTR  lptstrDoc, lptstrPos ;

					 // Read in the edit document

	iLength = GetWindowTextLength (hwndEdit) ;

	if (NULL == (lptstrDoc = (LPTSTR) malloc ((iLength + 1) * sizeof(TCHAR))))
			return FALSE ;

	GetWindowText (hwndEdit, lptstrDoc, iLength + 1) ;

					 // Search the document for the find string

	lptstrPos = _tcsstr (lptstrDoc + *piSearchOffset, szFindText) ;
	free (lptstrDoc) ;

					 // Return an error code if the string cannot be found

	if (lptstrPos == NULL)
			return FALSE ;

					 // Find the position in the document and the new start offset

	iPos = lptstrPos - lptstrDoc ;
	*piSearchOffset = iPos + lstrlen (szFindText) ;

					 // Select the found text

	SendMessage (hwndEdit, EM_SETSEL, iPos, *piSearchOffset) ;
	SendMessage (hwndEdit, EM_SCROLLCARET, 0, 0) ;

	return TRUE ;
}

//------------------------------------------------------
// PopFindNextText
//------------------------------------------------------

BOOL PopFindNextText (HWND hwndEdit, int *piSearchOffset)
{
	return PopFindFindText (hwndEdit, piSearchOffset, szFindText) ;
}


//------------------------------------------------------
// PopFindReplaceText
//------------------------------------------------------

BOOL PopFindReplaceText (HWND hwndEdit, int *piSearchOffset, LPTSTR szFindText)
{
					 // Find the text

	if (!PopFindFindText (hwndEdit, piSearchOffset, szFindText))
			return FALSE ;

					 // Replace it

	SendMessage (hwndEdit, EM_REPLACESEL, 0, (LPARAM) szReplText) ;

	return TRUE ;
}

//------------------------------------------------------
// PopFindValidFind
//------------------------------------------------------

BOOL PopFindValidFind (void)
{
	return *szFindText != '\0' ;
}

